const electron = require('electron');
const url = require('url');
const path = require('path');

const { app, BrowserWindow, Menu } = electron;

process.env.NODE_ENV = 'production';

let mainWindow;
let gameWindow;
let guideWindow;
let creditsWindow;

// Listen for app to be ready
app.on('ready', function() {
    // Create new window
    mainWindow = new BrowserWindow({
        maximizable: false,
        height: 150,
        width: 300
    });
    // Load html in window
    mainWindow.loadURL(url.format({
        pathname: path.join(__dirname, 'mainWindow.html'),
        protocol: 'file:',
        slashes: true
    }));
    // Quit app when closed
    mainWindow.on('closed', function() {
        app.quit();
    });

    // Build menu from template
    const mainMenu = Menu.buildFromTemplate(mainMenuTemplate);
    // Insert menu
    Menu.setApplicationMenu(mainMenu);
})

// Handle create game window
function startGameWindow() {
    // Create new window
    gameWindow = new BrowserWindow({
        minWidth: 500,
        maxWidth: 500,
        minHeight: 500,
        maxHeight: 500,
        width: 500,
        height: 500,
        center: true,
        maximizable: false,
        title: 'Midget Jump'
    });
    //load html into window
    gameWindow.loadURL(url.format({
        pathname: path.join(__dirname, 'index.html'),
        protocol: 'file:',
        slashes: true
    }));
    // Garbage collection handle
    gameWindow.on('close', function() {
        gameWindow = null;
    })
}

// Handle guide window
function startGuideWindow() {
    // Create new window
    guideWindow = new BrowserWindow({
        maximizable: false,
        width: 500,
        height: 400,
        title: 'Cum se joacă?'
    });
    // load html into window
    guideWindow.loadURL(url.format({
        pathname: path.join(__dirname, 'guide.html'),
        protocol: 'file:',
        slashes: true
    }));
    // Garbage collection handle
    guideWindow.on('close', function() {
        guideWindow = null;
    })
}

// Handle credits window
function startCreditsWindow() {
    // Create new window
    creditsWindow = new BrowserWindow({
        maximizable: false,
        width: 700,
        height: 300,
        title: 'Credits'
    });
    // Load html into window
    creditsWindow.loadURL(url.format({
        pathname: path.join(__dirname,'credits.html'),
        protocol: 'file:',
        slashes: true
    }));
    // Garbage collection handle
    creditsWindow.on('close',function() {
        creditsWindow = null;
    });
}

// Create main menu template
const mainMenuTemplate = [{
        label: 'Opțiuni',
        submenu: [{
            label: 'Ieșire',
            accelerator: process.platform == 'darwin' ? 'Command+E' : 'Ctrl+E',
            click() {
                app.quit();
            }
        }]
    },
    {
        label: 'Start',
        click() {
            startGameWindow()
        }
    },
    {
        label: 'Cum se joacă?',
        accelerator: process.platform == 'darwin' ? 'Command+H' : 'Ctrl+H',
        click() {
            startGuideWindow();
        }
    },
    {
        label: 'Credite',
        accelerator: process.platform == 'darwin' ? 'Command+F' : 'Ctrl+F',
        click() {
            startCreditsWindow();
        }
    }
];

// If mac, add empty object to menu
if (process.platform == 'darwin') {
    mainMenuTemplate.unshift({});
}

// Add developer tools item if not in production
if (process.env.NODE_ENV !== 'production') {
    mainMenuTemplate.push({
        label: 'Developer Tools',
        submenu: [{
                label: 'Toggle Developer Tools',
                accelerator: process.platform == 'darwin' ? 'Command+I' : 'Ctrl+I',
                click(item, focusedWindow) {
                    focusedWindow.toggleDevTools();
                }
            },
            {
                role: 'reload'
            }
        ]
    });
}